<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Marketer extends Model 
{

    protected $table = 'marketers';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone');

    public function users()
    {
        return $this->hasMany('App\Models\User');
    }

    public function commissions()
    {
        return $this->morphMany('App\Modules\Commission\Entities\Commission', 'commissionable');
    }

}